/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.command.ClientCommandBase;
import codechicken.lib.command.help.IBetterHelpCommand;
import codechicken.lib.util.ArrayUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ItemInfoCommand
extends ClientCommandBase
implements IBetterHelpCommand {
    @Override
    public void execute(Minecraft mc, EntityPlayerSP player, String[] args) throws CommandException {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() && (stack = player.func_184592_cb()).func_190926_b()) {
            player.func_145747_a((ITextComponent)new TextComponentString("You do not appear to be holding anything."));
            return;
        }
        boolean nbtToClipboard = args.length >= 1 && Boolean.parseBoolean(args[1]);
        String nbt = stack.func_77942_o() ? stack.func_77978_p().toString() : "Item has no NBT.";
        List ores = ArrayUtils.toList(OreDictionary.getOreIDs((ItemStack)stack)).stream().map(OreDictionary::getOreName).collect(Collectors.toList());
        player.func_145747_a((ITextComponent)new TextComponentString("RegistryName: " + stack.func_77973_b().getRegistryName()));
        player.func_145747_a((ITextComponent)new TextComponentString("Meta: " + stack.func_77960_j()));
        player.func_145747_a((ITextComponent)new TextComponentString("OreDictionary:"));
        for (String ore : ores) {
            player.func_145747_a((ITextComponent)new TextComponentString("  " + ore));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("NBT: " + nbt));
        if (nbtToClipboard && stack.func_77942_o()) {
            StringSelection sel = new StringSelection(nbt);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
            player.func_145747_a((ITextComponent)new TextComponentString("NBT Copied to clipboard!"));
        }
    }

    public String func_71517_b() {
        return "item_info";
    }

    public int func_82362_a() {
        return 0;
    }

    @Override
    public String getDesc() {
        return "Dumps some info on the item you are holding.";
    }

    @Override
    public List<String> getHelp() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("{} Defines optional choice parameters.");
        lines.add("Syntax: '/ccl item_info {true|false}");
        lines.add("Specifying true as the parameter will copy the NBT of the item to your clipboard.");
        lines.add("If you don't specify the parameter it will default to false.");
        lines.add("The command will attempt to use the item in your MainHand, failing that it will attempt your OffHand.");
        return lines;
    }
}

