/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.configuration;

import codechicken.lib.configuration.IConfigValue;
import codechicken.lib.configuration.ISerializableConfigTag;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ThrowingBiConsumer;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface IConfigTag<E extends IConfigTag>
extends IConfigValue<E>,
ISerializableConfigTag<E> {
    public boolean hasParent();

    @Nullable
    public E getParent();

    public boolean isCategory();

    public boolean isValue();

    public String getName();

    public String getUnlocalizedName();

    public boolean isDirty();

    public E markDirty();

    public void clear();

    public boolean hasTag(String var1);

    public E getTag(String var1);

    @Nullable
    public E getTagIfPresent(String var1);

    public E deleteTag(String var1);

    public List<String> getChildNames();

    public void walkTags(Consumer<E> var1);

    public E resetToDefault();

    public String getTagVersion();

    public E setTagVersion(String var1);

    public TagType getTagType();

    public E setComment(String var1);

    public E setComment(String ... var1);

    public E setComment(List<String> var1);

    default public void save() {
        if (this.hasParent()) {
            this.getParent().save();
        }
    }

    public E setSyncToClient();

    public E setSyncCallback(ThrowingBiConsumer<E, SyncType, SyncException> var1);

    public boolean requiresSync();

    default public void runSync() {
        try {
            this.runSync(SyncType.MANUAL);
        }
        catch (SyncException e) {
            throw new RuntimeException("Sync exception caught on manual sync.", e);
        }
    }

    public void runSync(SyncType var1) throws SyncException;

    public Object getRawValue();

    public static class SyncException
    extends Exception {
        public SyncException(String reason) {
            super(reason);
        }
    }

    public static enum SyncType {
        MANUAL,
        CONNECT,
        DISCONNECT;

    }

    public static enum TagType {
        BOOLEAN{

            @Override
            public char getChar() {
                return 'B';
            }

            @Override
            public Object copy(Object value) {
                return value;
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readBoolean();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeBoolean((Boolean)value);
            }
        }
        ,
        STRING{

            @Override
            public char getChar() {
                return 'S';
            }

            @Override
            public Object copy(Object value) {
                return value;
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readString();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeString((String)value);
            }
        }
        ,
        INT{

            @Override
            public char getChar() {
                return 'I';
            }

            @Override
            public Object copy(Object value) {
                return value;
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readVarInt();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeVarInt((Integer)value);
            }
        }
        ,
        HEX{

            @Override
            public char getChar() {
                return 'H';
            }

            @Override
            protected String processLine(Object obj) {
                Integer hex = (Integer)obj;
                return "0x" + Long.toString((long)hex.intValue() << 32 >>> 32, 16).toUpperCase();
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return INT.read(in, listType);
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                INT.write(out, listType, value);
            }

            @Override
            public Object copy(Object value) {
                return value;
            }
        }
        ,
        DOUBLE{

            @Override
            public char getChar() {
                return 'D';
            }

            @Override
            public Object copy(Object value) {
                return value;
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                return in.readDouble();
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                out.writeDouble((Double)value);
            }
        }
        ,
        LIST{

            @Override
            public char getChar() {
                return '#';
            }

            @Override
            public Object copy(Object value) {
                return new LinkedList((List)value);
            }

            @Override
            public Object read(MCDataInput in, TagType listType) {
                LinkedList<Object> list = new LinkedList<Object>();
                int num = in.readVarInt();
                for (int i = 0; i < num; ++i) {
                    list.add(listType.read(in, listType));
                }
                return list;
            }

            @Override
            public void write(MCDataOutput out, TagType listType, Object value) {
                List list = (List)value;
                out.writeVarInt(list.size());
                for (Object o : list) {
                    listType.write(out, listType, o);
                }
            }
        };


        public abstract char getChar();

        public abstract Object copy(Object var1);

        protected String processLine(Object obj) {
            return obj.toString();
        }

        public static TagType fromChar(char c) {
            switch (c) {
                case 'B': {
                    return BOOLEAN;
                }
                case 'S': {
                    return STRING;
                }
                case 'I': {
                    return INT;
                }
                case 'D': {
                    return DOUBLE;
                }
                case 'H': {
                    return HEX;
                }
            }
            return null;
        }

        public abstract Object read(MCDataInput var1, TagType var2);

        public abstract void write(MCDataOutput var1, TagType var2, Object var3);
    }
}

