/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import openblocks.OpenBlocks;
import openmods.infobook.BookDocumentation;
import openmods.utils.ItemUtils;

@BookDocumentation
public class ItemSlimalyzer
extends Item {
    private static final String TAG_ACTIVE = "Active";

    public ItemSlimalyzer() {
        this.func_185043_a(new ResourceLocation("active"), (stack, worldIn, entityIn) -> ItemSlimalyzer.isActive(stack) ? 2.0f : 0.0f);
    }

    private static boolean isActive(ItemStack stack) {
        NBTTagCompound itemTag = stack.func_77978_p();
        return itemTag != null && itemTag.func_74767_n(TAG_ACTIVE);
    }

    private static boolean isInSlimeChunk(World world, Entity entity) {
        if (world == null || entity == null) {
            return false;
        }
        Chunk chunk = world.func_175726_f(entity.func_180425_c());
        return chunk.func_76617_a(987234911L).nextInt(10) == 0;
    }

    private static boolean update(@Nonnull ItemStack stack, World world, Entity entity) {
        boolean isInSlimeChunk;
        boolean isActive = ItemSlimalyzer.isActive(stack);
        if (isActive != (isInSlimeChunk = ItemSlimalyzer.isInSlimeChunk(world, entity))) {
            if (isInSlimeChunk) {
                world.func_184133_a(null, entity.func_180425_c(), OpenBlocks.Sounds.ITEM_SLIMALYZER_PING, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            ItemUtils.getItemTag((ItemStack)stack).func_74757_a(TAG_ACTIVE, isInSlimeChunk);
            return true;
        }
        return false;
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            ItemSlimalyzer.update(stack, world, entity);
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack stack;
        World world = entityItem.field_70170_p;
        if (!world.field_72995_K && ItemSlimalyzer.update(stack = entityItem.func_92059_d(), world, (Entity)entityItem)) {
            entityItem.func_92058_a(stack);
        }
        return false;
    }
}

