/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity.ai;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openmods.OpenMods;
import openmods.fakeplayer.BreakBlockAction;
import openmods.fakeplayer.FakePlayerPool;

public class EntityAIBreakBlock
extends EntityAIBase {
    private EntityLiving entity;
    private PathNavigate pathFinder;
    private BlockPos blockCoord;
    private int tickOffset = 0;
    private Random rand;

    public EntityAIBreakBlock(EntityLiving minime) {
        this.entity = minime;
        this.pathFinder = minime.func_70661_as();
        this.func_75248_a(3);
        this.rand = new Random(minime.func_145782_y());
        this.tickOffset = this.rand.nextInt(10);
    }

    public boolean func_75250_a() {
        boolean hasTicked;
        if (!this.pathFinder.func_75500_f()) {
            return false;
        }
        boolean bl = hasTicked = (OpenMods.proxy.getTicks(this.entity.field_70170_p) + (long)this.tickOffset) % 4L == 0L;
        if (hasTicked && this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                int x = this.rand.nextInt(16) - 8;
                int y = this.rand.nextInt(3) - 1;
                int z = this.rand.nextInt(16) - 8;
                this.blockCoord = new BlockPos((double)x + this.entity.field_70165_t, (double)y + this.entity.field_70163_u, (double)z + this.entity.field_70161_v);
                if (this.canHarvestBlock(this.blockCoord)) {
                    return true;
                }
                this.blockCoord = null;
            }
        }
        return false;
    }

    public void func_75251_c() {
        this.pathFinder.func_75499_g();
        this.blockCoord = null;
    }

    public boolean func_75253_b() {
        return this.entity.func_70089_S() && !this.pathFinder.func_75500_f() && this.blockCoord != null && this.canHarvestBlock(this.blockCoord);
    }

    public void func_75249_e() {
        if (this.blockCoord != null) {
            Path pathentity = this.pathFinder.func_179680_a(this.blockCoord);
            this.pathFinder.func_75484_a(pathentity, 1.0);
        }
    }

    public void func_75246_d() {
        super.func_75246_d();
        World world = this.entity.field_70170_p;
        if (world instanceof WorldServer && this.blockCoord != null && this.canHarvestBlock(this.blockCoord) && this.entity.func_174831_c(this.blockCoord) < 1.0) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)world, (FakePlayerPool.PlayerUserReturning)new BreakBlockAction(world, this.blockCoord).setStackToUse(ItemStack.field_190927_a));
            this.blockCoord = null;
        }
    }

    public boolean canHarvestBlock(BlockPos coord) {
        Block block = this.entity.field_70170_p.func_180495_p(coord).func_177230_c();
        return block instanceof BlockFlower || block == Blocks.field_150478_aa;
    }
}

