/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.Config;
import openmods.Log;
import openmods.block.OpenBlock;
import org.apache.logging.log4j.Level;

public class BlockGrave
extends OpenBlock.FourDirections {
    public static final IProperty<Boolean> HAS_BASE = PropertyBool.func_177716_a((String)"base");
    private static final int MASK_HAS_BASE = 8;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);

    public BlockGrave() {
        super(Material.field_151578_c);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(HAS_BASE, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), HAS_BASE});
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(HAS_BASE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b(HAS_BASE) != false ? 8 : 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean canRotateWithTool() {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    private static Level debugLevel() {
        return Config.debugGraves ? Level.INFO : Level.DEBUG;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        Log.log((Level)BlockGrave.debugLevel(), (String)"Grave @ (%s) dimension = %d destroyed", (Object[])new Object[]{pos, world.field_73011_w.getDimension()});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        Log.log((Level)BlockGrave.debugLevel(), (String)"Grave @ (%s) dimension = %d destroyed by player %s", (Object[])new Object[]{pos, world.field_73011_w.getDimension(), player});
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(world, pos, explosionIn);
        Log.log((Level)BlockGrave.debugLevel(), (String)"Grave @ (%s) dimension = %d destroyed by explosion", (Object[])new Object[]{pos, world.field_73011_w.getDimension()});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(HAS_BASE, (Comparable)Boolean.valueOf(this.hasBase((IBlockAccess)world, pos)));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos blockPos, Block neighbour, BlockPos neighbourPos) {
        if (neighbourPos.equals((Object)blockPos.func_177977_b())) {
            IBlockState newState = state.func_177226_a(HAS_BASE, (Comparable)Boolean.valueOf(this.hasBase((IBlockAccess)world, blockPos)));
            if (newState != state) {
                world.func_180501_a(blockPos, newState, 2);
            }
            super.func_189540_a(newState, world, blockPos, neighbour, neighbourPos);
        } else {
            super.func_189540_a(state, world, blockPos, neighbour, neighbourPos);
        }
    }

    protected boolean hasBase(IBlockAccess world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos.func_177977_b());
        Material material = block.func_185904_a();
        return material == Material.field_151577_b || material == Material.field_151578_c;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

