/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import com.google.common.base.Supplier;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import openblocks.client.renderer.tileentity.guide.IGuideRenderer;
import openblocks.client.renderer.tileentity.guide.MarkerRenderer;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.shapes.CoordShape;
import openmods.utils.TextureUtils;

public class GuideAdvancedRenderer
implements IGuideRenderer {
    private final MarkerRenderer mr = new MarkerRenderer();

    @Override
    public void renderShape(TileEntityGuide guide) {
        CoordShape toDelete;
        float scaleDelta = guide.getTimeSinceChange();
        this.renderShape(guide.getShape(), guide.getColor(), scaleDelta);
        if ((double)scaleDelta < 1.0) {
            this.renderShape(guide.getPreviousShape(), guide.getColor(), 1.0f - scaleDelta);
        }
        if ((toDelete = guide.getAndDeleteShape()) != null && this.mr != null) {
            this.mr.deleteShape(toDelete);
        }
    }

    private void renderShape(CoordShape shape, int color, float scale) {
        if (shape == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179140_f();
        TextureUtils.bindTextureToClient((ResourceLocation)TextureMap.field_110575_b);
        this.mr.drawInstanced(shape, color, scale);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    @Override
    public void onModelBake(Supplier<BufferBuilder> modelSupplier) {
        this.mr.setModel(modelSupplier);
    }
}

