/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import openblocks.common.HeightMapData;
import openmods.renderer.DynamicTextureAtlas;
import org.lwjgl.opengl.GL11;

public class HeightMapRenderer {
    public static final HeightMapRenderer instance = new HeightMapRenderer();
    public static final double PLANE_HEIGHT = 0.015625;
    private final Map<Integer, MapRenderData> cache = Maps.newHashMap();

    private HeightMapRenderer() {
    }

    protected void finalize() throws Throwable {
        for (MapRenderData data : this.cache.values()) {
            data.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int mapId, HeightMapData data) {
        MapRenderData renderData;
        Map<Integer, MapRenderData> map = this.cache;
        synchronized (map) {
            renderData = this.cache.get(mapId);
            if (renderData == null) {
                renderData = new MapRenderData();
                this.cache.put(mapId, renderData);
            }
        }
        if (renderData.needsUpdate(data)) {
            renderData.update(data);
        }
        renderData.render();
    }

    private static class MapRenderData {
        public int renderedDataHash;
        public DynamicTextureAtlas atlas;
        public Integer displayList;

        private MapRenderData() {
        }

        public void free() {
            if (this.displayList != null) {
                GL11.glDeleteLists((int)this.displayList, (int)1);
                this.displayList = null;
            }
        }

        private List<PlaneData> updateMapTexture(HeightMapData map) {
            TextureManager manager = Minecraft.func_71410_x().field_71446_o;
            if (this.atlas == null) {
                this.atlas = new DynamicTextureAtlas(manager, 64);
            }
            this.atlas.clearCells();
            ArrayList planes = Lists.newArrayList();
            this.createXZPlanes(map, planes);
            if (!planes.isEmpty()) {
                this.atlas.compile();
            }
            return planes;
        }

        private void createXZPlanes(HeightMapData map, List<PlaneData> planes) {
            int[][] levels = new int[256][];
            for (HeightMapData.LayerData layer : map.layers) {
                for (int x = 0; x < 64; ++x) {
                    for (int y = 0; y < 64; ++y) {
                        int index = 64 * y + x;
                        byte color = layer.colorMap[index];
                        if (color == 0) continue;
                        int height = layer.heightMap[index] & 0xFF;
                        int fullColor = MapColor.field_76281_a[color].field_76291_p;
                        int[] plane = MapRenderData.getPlane(levels, height);
                        plane[index] = fullColor | layer.alpha << 24;
                    }
                }
            }
            this.createPlanes(planes, levels, PlaneOrientation.XZ);
        }

        public static int[] getPlane(int[][] levels, int height) {
            int[] level = levels[height];
            if (level == null) {
                level = new int[4096];
                levels[height] = level;
            }
            return level;
        }

        private void createPlanes(List<PlaneData> planes, int[][] levels, PlaneOrientation orientation) {
            for (int z = 0; z < levels.length; ++z) {
                int[] level = levels[z];
                if (level == null) continue;
                PlaneData plane = new PlaneData();
                plane.orientation = orientation;
                plane.param = z;
                plane.texture = this.atlas.allocateCell();
                plane.texture.setPixels(level);
                planes.add(plane);
            }
        }

        private void compileDisplayList(List<PlaneData> planes) {
            if (this.displayList == null) {
                this.displayList = GL11.glGenLists((int)1);
            }
            GL11.glNewList((int)this.displayList, (int)4864);
            Tessellator tes = new Tessellator(160);
            BufferBuilder wr = tes.func_178180_c();
            wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (PlaneData plane : planes) {
                DynamicTextureAtlas.AtlasCell tex = plane.texture;
                double param = 0.015625 * (double)plane.param;
                switch (plane.orientation) {
                    case XZ: {
                        wr.func_181662_b(0.0, param, 0.0).func_187315_a((double)tex.minU, (double)tex.minV).func_181675_d();
                        wr.func_181662_b(0.0, param, 1.0).func_187315_a((double)tex.minU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(1.0, param, 1.0).func_187315_a((double)tex.maxU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(1.0, param, 0.0).func_187315_a((double)tex.maxU, (double)tex.minV).func_181675_d();
                        break;
                    }
                    case XY: {
                        wr.func_181662_b(0.0, 0.0, param).func_187315_a((double)tex.minU, (double)tex.minV).func_181675_d();
                        wr.func_181662_b(0.0, 1.0, param).func_187315_a((double)tex.minU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(1.0, 1.0, param).func_187315_a((double)tex.maxU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(1.0, 0.0, param).func_187315_a((double)tex.maxU, (double)tex.minV).func_181675_d();
                        break;
                    }
                    case YZ: {
                        wr.func_181662_b(param, 0.0, 0.0).func_187315_a((double)tex.minU, (double)tex.minV).func_181675_d();
                        wr.func_181662_b(param, 1.0, 0.0).func_187315_a((double)tex.minU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(param, 1.0, 1.0).func_187315_a((double)tex.maxU, (double)tex.maxV).func_181675_d();
                        wr.func_181662_b(param, 0.0, 1.0).func_187315_a((double)tex.maxU, (double)tex.minV).func_181675_d();
                        break;
                    }
                }
            }
            tes.func_78381_a();
            GL11.glEndList();
        }

        public boolean needsUpdate(HeightMapData map) {
            return System.identityHashCode((Object)map) != this.renderedDataHash;
        }

        public void update(HeightMapData map) {
            List<PlaneData> planes = this.updateMapTexture(map);
            this.compileDisplayList(planes);
            this.renderedDataHash = System.identityHashCode((Object)map);
        }

        public void render() {
            Preconditions.checkNotNull((Object)this.displayList, (Object)"Display list not compiled");
            this.atlas.bind();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            GL11.glCallList((int)this.displayList);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
        }
    }

    private static class PlaneData {
        public PlaneOrientation orientation;
        public int param;
        public DynamicTextureAtlas.AtlasCell texture;

        private PlaneData() {
        }
    }

    private static enum PlaneOrientation {
        XY,
        XZ,
        YZ;

    }
}

