/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.ImmutableList;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import openblocks.client.gui.StandardPalette;
import openblocks.common.FluidXpUtils;
import openblocks.common.container.ContainerAutoAnvil;
import openblocks.common.tileentity.TileEntityAutoAnvil;
import openmods.api.IValueReceiver;
import openmods.container.ContainerBase;
import openmods.gui.GuiConfigurableSlots;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.GuiComponentTab;
import openmods.gui.component.GuiComponentTankLevel;
import openmods.gui.logic.IValueUpdateAction;
import openmods.gui.logic.ValueCopyAction;
import openmods.utils.MiscUtils;
import openmods.utils.TranslationUtils;

public class GuiAutoAnvil
extends GuiConfigurableSlots<TileEntityAutoAnvil, ContainerAutoAnvil, TileEntityAutoAnvil.AutoSlots> {
    public GuiAutoAnvil(ContainerAutoAnvil container) {
        super((ContainerBase)container, 176, 175, "openblocks.gui.autoanvil");
    }

    protected void addCustomizations(BaseComposite main) {
        TileEntityAutoAnvil te = (TileEntityAutoAnvil)((Object)((ContainerAutoAnvil)this.getContainer()).getOwner());
        main.addComponent((BaseComponent)new GuiComponentSprite(80, 34, GuiComponentSprite.Sprites.hammer));
        main.addComponent((BaseComponent)new GuiComponentSprite(36, 41, GuiComponentSprite.Sprites.plus));
        GuiComponentTankLevel tankLevel = new GuiComponentTankLevel(140, 30, 17, 37, 45);
        tankLevel.setDisplayFluidNameInTooltip(false);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getFluidProvider(), (IValueReceiver)tankLevel.fluidReceiver(), FluidXpUtils.FLUID_TO_LEVELS));
        main.addComponent((BaseComponent)tankLevel);
    }

    protected Iterable<TileEntityAutoAnvil.AutoSlots> getSlots() {
        return ImmutableList.of((Object)((Object)TileEntityAutoAnvil.AutoSlots.tool), (Object)((Object)TileEntityAutoAnvil.AutoSlots.modifier), (Object)((Object)TileEntityAutoAnvil.AutoSlots.xp), (Object)((Object)TileEntityAutoAnvil.AutoSlots.output));
    }

    protected GuiComponentTab createTab(TileEntityAutoAnvil.AutoSlots slot) {
        switch (slot) {
            case modifier: {
                return new GuiComponentTab(StandardPalette.lightblue.getColor(), new ItemStack(Items.field_151134_bR, 1), 100, 100);
            }
            case output: {
                ItemStack enchantedAxe = new ItemStack(Items.field_151046_w, 1);
                enchantedAxe.func_77966_a(Enchantments.field_185308_t, 1);
                return new GuiComponentTab(StandardPalette.green.getColor(), enchantedAxe, 100, 100);
            }
            case tool: {
                return new GuiComponentTab(StandardPalette.blue.getColor(), new ItemStack(Items.field_151046_w, 1), 100, 100);
            }
            case xp: {
                return new GuiComponentTab(StandardPalette.yellow.getColor(), new ItemStack(Items.field_151133_ar, 1), 100, 100);
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    protected GuiComponentLabel createLabel(TileEntityAutoAnvil.AutoSlots slot) {
        switch (slot) {
            case modifier: 
            case tool: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autoextract"));
            }
            case output: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autoeject"));
            }
            case xp: {
                return new GuiComponentLabel(22, 82, TranslationUtils.translateToLocal((String)"openblocks.gui.autodrink"));
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }
}

