/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.core.block.BlockCore;
import cofh.core.block.ItemBlockCore;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBlockDuct
extends ItemBlockCore {
    int offset;

    public ItemBlockDuct(BlockCore block) {
        super(block);
        this.offset = ((BlockDuct)block).offset;
    }

    public String func_77667_c(ItemStack item) {
        return TDDucts.isValid(this.id(item)) ? "tile.thermaldynamics.duct." + TDDucts.getType((int)this.id((ItemStack)item)).unlocalizedName : super.func_77667_c(item);
    }

    public String func_77653_i(ItemStack item) {
        if (TDDucts.isValid(this.id(item))) {
            Duct type = TDDucts.getType(this.id(item));
            String opaqueLocalized = null;
            String modeLocalized = null;
            String unloc = this.func_77657_g(item);
            if (type.opaque) {
                if (StringHelper.canLocalize((String)(unloc + ".opaque.name"))) {
                    unloc = unloc + ".opaque";
                } else {
                    opaqueLocalized = "tile.thermaldynamics.duct.opaque.name";
                }
            }
            if (type instanceof DuctItem && item.func_77978_p() != null) {
                if (item.func_77978_p().func_74771_c("DenseType") == 1) {
                    if (StringHelper.canLocalize((String)(unloc + ".dense.name"))) {
                        unloc = unloc + ".dense";
                    } else {
                        modeLocalized = "tile.thermaldynamics.duct.dense.name";
                    }
                } else if (item.func_77978_p().func_74771_c("DenseType") == 2) {
                    if (StringHelper.canLocalize((String)(unloc + ".vacuum.name"))) {
                        unloc = unloc + ".vacuum";
                    } else {
                        modeLocalized = "tile.thermaldynamics.duct.vacuum.name";
                    }
                }
            }
            String ret = StringHelper.localize((String)(unloc + ".name"));
            if (opaqueLocalized != null) {
                ret = StringHelper.localizeFormat((String)opaqueLocalized, (Object[])new Object[]{ret});
            }
            if (modeLocalized != null) {
                ret = StringHelper.localizeFormat((String)modeLocalized, (Object[])new Object[]{ret});
            }
            return ret;
        }
        return super.func_77653_i(item);
    }

    public int id(ItemStack item) {
        return this.offset + item.func_77952_i();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int ductId = this.id(stack);
        if (TDDucts.isValid(ductId)) {
            return TDDucts.getType((int)ductId).rarity;
        }
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)TDDucts.structure.itemStack)) {
                tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
            }
            return;
        }
        int ductId = this.id(stack);
        if (!TDDucts.isValid(ductId)) {
            return;
        }
        Duct duct = TDDucts.getType(ductId);
        switch (duct.ductType) {
            case ENERGY: {
                tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.energy"));
                if (duct != TDDucts.energySuperCond) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + GridEnergy.XFER[duct.type] + "\u00a77" + " RF/t.");
                } else {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7b" + StringHelper.localize((String)"info.cofh.infinite") + "\u00a77" + " RF/t.");
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.energySuper.info"));
                }
                tooltip.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferConnection"));
                break;
            }
            case FLUID: {
                if (duct.type == 0) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidBasic.info"));
                } else if (duct.type == 1) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidHardened.info"));
                } else if (duct.type == 2) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluidEnergy"));
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + GridEnergy.XFER[1] + "\u00a77" + " RF/t.");
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidHardened.info"));
                } else if (duct.type == 3) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.fluid"));
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.fluidSuper.info"));
                }
                if (duct.type == 3) break;
                tooltip.add(StringHelper.getNoticeText((String)"info.thermaldynamics.transferFluid"));
                break;
            }
            case ITEM: {
                if (duct.type == 0) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.item"));
                } else if (duct.type == 1) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.item"));
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemFast.info"));
                } else if (duct.type == 2) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.itemEnergy"));
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + GridEnergy.XFER[1] + "\u00a77" + " RF/t.");
                } else if (duct.type == 3) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.itemEnergy"));
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.transfer") + ": " + "\u00a7e" + GridEnergy.XFER[1] + "\u00a77" + " RF/t.");
                    tooltip.add(StringHelper.getInfoText((String)"tile.thermaldynamics.duct.itemFast.info"));
                }
                if (!stack.func_77942_o()) break;
                byte pathWeight = stack.func_77978_p().func_74771_c("DenseType");
                if (pathWeight == 1) {
                    tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.dense"));
                    break;
                }
                if (pathWeight != 2) break;
                tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.vacuum"));
                break;
            }
            case STRUCTURAL: {
                if (duct == TDDucts.structure) {
                    tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                    tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.cover"));
                    break;
                }
                if (duct != TDDucts.lightDuct) break;
                tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.structure"));
                tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.light"));
                break;
            }
            case TRANSPORT: {
                tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.transport"));
                if (duct == TDDucts.transportLongRange) {
                    tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.transportLongRange"));
                    break;
                }
                if (duct != TDDucts.transportLinking) break;
                tooltip.add(StringHelper.getInfoText((String)"info.thermaldynamics.duct.transportCrossover"));
                break;
            }
            case CRAFTING: {
                tooltip.add(StringHelper.localize((String)"info.thermaldynamics.duct.crafting"));
                break;
            }
        }
    }
}

